 /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Data.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "CRYS_SST_Ext_ATP_Asym.h"
#include "MW_ATP_UTIL_funcs.h"
#include "ExtApp_HOST_TST_Message.h"
#include "SST_Ext_ATP_AuthenticatorsTstVectors.h"
extern DxError_t      EXT_TST_ATP_Error;
extern DxError_t      EXT_TST_TestStatus;
 
 #if TST_USE_CRYS_SST_SYM_MODULE


/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_Ext_ATP_RSA         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module 
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
  
DxError_t CRYS_SST_Ext_ATP_RSA  ( void )
{
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA";
    
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;
    
    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
  
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n")); 
            
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OP_CODE,
                                           sizeof(SEP_ATP_PassAuthTestDataStruct),
                                           SEP_ATP_PassAuthObjectTestData);
											    
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_RSA", 
											      "CRYS_SST_Ext_ATP_RSA",TST_MasterTestName); 
    return EXT_TST_TestStatus;
    
}/* End of CRYS_SST_Ext_ATP_RSA */

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module 
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/ 
  
DxError_t CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC  ( void )
{
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA_OAEP_ENCDEC ";
    
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

  
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n")); 
 
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_OAEP_ENCDEC_OP_CODE, 
                                           sizeof(SEP_ATP_PassAuthTestDataStruct),
                                           SEP_ATP_PassAuthObjectTestData);
											    
											    
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_RSA_OAEP_ENCDEC", 
											      "CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC",TST_MasterTestName); 
    return EXT_TST_TestStatus;
    
}/* End of CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC */

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_SST_Ext_ATP_RSA_Prim         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *    Test the connection between CRYS and the SSTfunctionality while using SST RSA generated keys
 *    in the CRYS_SST module 
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function 
 *
 *******************************************************************************/ 
  
DxError_t CRYS_SST_Ext_ATP_RSA_Prim  ( void )
{
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_SST_TST_ATP_RSA_Prim";
    
    /********* TST Variables initialization *********/
   EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
 
    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n")); 
            
    EXT_TST_ATP_Error = HOSTQA_ATP_Message(DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_RSA_PRIM_OP_CODE, 
                                           sizeof(SEP_ATP_PassAuthTestDataStruct),
                                           SEP_ATP_PassAuthObjectTestData);
											    
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_RSA_OAEP_ENCDEC", 
											      "CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC",TST_MasterTestName); 
    return EXT_TST_TestStatus;
    
}/* End of CRYS_SST_Ext_ATP_RSA_Prim */




#endif
